#include "..\..\DLL\d_iNES.h"

namespace {
uint8_t reg[4];

void sync (void) {
	if (reg[3] &0x01) {
		if (reg[2] &0x20) {
			EMU->SetPRG_ROM16(0x8, reg[2] >>3 &~0x07 | reg[1] &0x07);
			EMU->SetPRG_ROM16(0xC, reg[2] >>3 &~0x07 |         0x07);
		} else {
			EMU->SetPRG_ROM16(0x8, reg[2] >>3 &~0x03 | reg[1] &0x07);
			EMU->SetPRG_ROM16(0xC, reg[2] >>3 &~0x03 | reg[1] &0x04 | 0x03);
		}
	} else {
		EMU->SetPRG_ROM16(0x8, reg[2] >>3 &~0x07 | reg[1] &~1);
		EMU->SetPRG_ROM16(0xC, reg[2] >>3 &~0x07 | reg[1] | 1);
	}
	iNES_SetCHR_Auto8(0x0, 0);
	if (reg[0] &0x01)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

void MAPINT writeReg (int bank, int addr, int val) {
	reg[bank >>2 &1] = val;
	if (~bank &4) reg[2] = addr &0xFF;
	if (~bank &4) reg[3] = addr >>8;
	sync();
}

void MAPINT reset (RESET_TYPE resetType) {
	reg[0] = 0; reg[1] = 1; reg[2] = 0; reg[3] = 0;
	sync();
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUWriteHandler(bank, writeReg);
}

int MAPINT saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	for (auto& c: reg) SAVELOAD_BYTE(stateMode, offset, data, c);
	if (stateMode == STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum = 301;
} // namespace

MapperInfo MapperInfo_605 = {
	&mapperNum,
	_T("TX5/8IN1"),
	COMPAT_FULL,
	NULL,
	reset,
	NULL,
	NULL,
	NULL,
	saveLoad,
	NULL,
	NULL
};